<?php

namespace App\Http\Controllers\Administrator;

use App\Models\Website;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;


class WebsiteController extends Controller
{

	public function index(Request $request)
	{
		$websites = new Website();

		$data = array(
			'title' => 'Websites',
			'all_websites' => $websites->latest()->paginate(10),
		);
		return view('admin.websites.index')->with($data);
	}

	public function save(Request $request)
	{
		$rules = [
			'name' => ['required', 'string'],
			'status' => ['required'],
		];

		$validator = Validator::make($request->all(), $rules);
		if ($validator->fails()) {
			return ['errors' => $validator->errors()];
		}
		$website = new  Website();
		if ($request->id) {
			$website = $website::hashidFind($request->id);
			$msg = [
				'success' => 'Website Successfully Updated',
				'redirect' => route('admin.websites'),
			];
		} else {
			$msg = [
				'success' => 'Website Successfully Added',
				'redirect' => route('admin.websites'),
			];
		}

		$website->name = $request->name;
		$website->status = $request->status;
		$website->save();

		return response()->json($msg);
	}

	public function edit($id)
	{
		$website = Website::hashidFind($id);
        $all_websites = new Website();
		$data = array(
			'title' => 'Website',
			'edit' => $website,
            'all_websites' => $all_websites->latest()->paginate(10),
		);
		return view('admin.websites.index')->with($data);
	}

	public function delete($id)
	{
		Website::hashidFind($id)->delete();
		return response()->json([
			'success' => 'Website Successfully Deleted',
			'remove_tr' => true
		]);
	}
}
