<?php

namespace App\Models;

use App\Traits\DianujHashidsTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Role extends Model
{
    use SoftDeletes, DianujHashidsTrait;
    protected $guarded = [];
    protected $casts = ['user_permissions' => 'object'];

    public function user()
    {
        return $this->belongsTo(Admin::class, 'added_by_id');
    }
}
