<?php

namespace App\Traits;

use Illuminate\Database\Eloquent\Builder;

trait ByStoreIdTrait
{
    public function getHashIdAttribute()
    {
        return hashids_encode($this->getKey());
    }
    
    public function scopeWhereHashid(Builder $query, $id, $column = 'id'){
        $id = hashids_decode($id);
        return $query->where($column, $id);
    }

    public function scopeHashidFind(Builder $query, $id){
        $id = hashids_decode($id);
        return $query->find($id);
    }

    public function scopeHashIdOrFail(Builder $query, $id)
    {
        $id = hashids_decode($id);
        return $query->findOrFail($id);
    }

    public function scopeWhereInHashIds(Builder $query, $ids, $column = 'id')
    {   
        $ids = array_map(function ($id){
            return hashids_decode($id);
        }, $ids);
        return $query->whereIn($column, $ids);
    }

}