@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="col-12">
        <div class="page-title-box">
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Dashboard</a></li>
                    <li class="breadcrumb-item active">{{$title}}</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-lg-12">
        <div class="card-box">
            <p class="sub-header">Here you can add the campaign ads.</p>
            <form action="{{route('admin.campaign_ads.save')}}" method="post" class="ajaxForm" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="campaign_id" value="{{$campaign_id}}">
                <input type="hidden" name="id" value="{{isset($edit) ? $edit->id : null}}">
                <div class="row">
                    <div class="form-group col-4">
                        <label for="ads_title">Ads Title</label>
                        <input type="text" class="form-control" name="ads_title" value="{{isset($edit) ? $edit->title : null}}" required>
                    </div>

                    <div class="form-group col-4">
                        <label for="ads_title">Ads Link</label>
                        <input type="text" class="form-control" name="ads_link" value="{{isset($edit) ? $edit->link : null}}" required>
                    </div>

                    <div class="form-group col-4">
                        <label for="ads_image">Ads Image &nbsp; (size: 930x180)</label>
                        <input class="form-control" type="file" name="ads_image" id="ads_image" {{isset($edit) ? null : 'required'}}>
                    </div>

                    <div class="form-group col-12">
                        <button class="btn btn-success">Save</button>
                    </div>
                </div>

            </form>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-lg-12">
        <div class="card-box">
            <div class="d-flex align-items-center justify-content-between">
                <h4 class="header-title">All Compaigns</h4>
                <a href="{{route('admin.compaign.add')}}" class="btn btn-success">Add Compaign</a>
            </div>
            <p class="sub-header">Following is the list of all the Compaigns.</p>
            <table id="responsive-datatable" class="table table-bordered dt-responsive nowrap">
                <thead class="">
                    <tr>
                        <th width="20">S.No</th>
                        <th>Title</th>
                        <th>Image</th>
                        <th>Views</th>
                        <th>Clicks</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @if (!empty($data) && count($data) > 0)
                    @foreach ($data as $key => $value)
                    <tr>
                        <td class="text-center align-middle">{{ $key+1 }}</td>
                        <td class="align-middle">  <a href="{{$value->link}}" target="_blank">{{ $value->title  }}</a> </td>
                        <td class="align-middle">
                            <img class="img" width="50%" src="{{asset($value->image)}}" alt="{{$value->title}}">
                        </td>
                        <td>{{$value->views}}</td>
                        <td>{{$value->clicks}}</td>
                        <td class="align-middle">
                            <a href="javascript:void(0)" data-url="{{route('admin.campaign_ads.ads_ifram_generate',$value->hashid)}}" class="btn btn-icon btn-sm waves-effect waves-light btn-info copy-ifram" title="Copy Ifram"> <i class="fas fa-copy"></i></a>
                            <a href="{{route('admin.campaign_ads.edit',['id'=>$value->hashid,'campaign_id'=>$value->campaign->hashid])}}" class="btn btn-icon btn-sm waves-effect waves-light btn-warning" title="Edit"> <i class="fas fa-edit"></i></a>
                            <button type="button" onclick="ajaxRequest(this)" data-url="{{route('admin.campaign_ads.delete',$value->hashid)}}" class="btn btn-icon btn-danger" title="Delete">
                                <i class="fa fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                    @endforeach
                    @else
                    <tr>
                        <td colspan="12" align="center">NO Compaigns Ads Found</td>
                    </tr>
                    @endif

                </tbody>
            </table>
            {{@$data->links('vendor.pagination.bootstrap-4')}}
        </div>
    </div>
</div>
@endsection
@section('page-scripts')
<script>
    function copyToClipboard(text) {
        var sampleTextarea = document.createElement("textarea");
        document.body.appendChild(sampleTextarea);
        sampleTextarea.value = text; //save main text in it
        sampleTextarea.select(); //select textarea contenrs
        document.execCommand("copy");
        document.body.removeChild(sampleTextarea);
    }

    $(document).ready(function() {
        validations = $(".ajaxForm").validate();
        $('.ajaxForm').submit(function(e) {
            e.preventDefault();
            validations = $(".ajaxForm").validate();
            if (validations.errorList.length != 0) {
                return false;
            }
            var url = $(this).attr('action');
            var param = new FormData(this);
            my_ajax(url, param, 'post', function(res) {

            });
        })

        $('.copy-ifram').click(function (e) {
            url = $(this).data('url');
            getAjaxRequests(url,{},'get',function (data) {
                copyToClipboard(data.view);
                alert('Ifram Copied');
            },false);
        })
    });


</script>
@endsection
