@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="col-12">
        <div class="page-title-box">
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Dashboard</a></li>
                    <li class="breadcrumb-item active">{{$title}}</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-lg-12">
        <div class="card-box">
            <div class="d-flex align-items-center justify-content-between">
                <h4 class="header-title">All Compaigns</h4>
                <a href="{{route('admin.compaign.add')}}" class="btn btn-success">Add Compaign</a>
            </div>
            <p class="sub-header">Following is the list of all the Compaigns.</p>
            <table id="responsive-datatable" class="table table-bordered dt-responsive nowrap">
                <thead class="">
                    <tr>
                        <th width="20">S.No</th>
                        <th>Website Name</th>
                        <th>Name</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @if (!empty($all_compaigns) && count($all_compaigns) > 0)
                    @foreach ($all_compaigns as $key => $value)
                    <tr>
                        <td class="text-center align-middle">{{ $key+1 }}</td>
                        <td class="align-middle">{{ $value->website->name  }}</td>
                        <td class="align-middle">{{ $value->name }}</td>
                        <td class="align-middle">{{ $value->start_date }}</td>
                        <td class="align-middle">{{ $value->end_date }}</td>
                        <td class="align-middle">
                            <a href="{{route('admin.campaign_ads.set',$value->hashid)}}" class="btn btn-icon btn-sm waves-effect waves-light btn-info" title="add ads images"> <i class="fas fa-plus"></i></a>
                            <a href="{{route('admin.compaign.edit',$value->hashid)}}" class="btn btn-icon btn-sm waves-effect waves-light btn-warning" title="Edit"> <i class="fas fa-edit"></i></a>
                            <button type="button" onclick="ajaxRequest(this)" data-url="{{route('admin.compaign.delete',$value->hashid)}}" class="btn btn-icon btn-danger" title="Delete">
                                <i class="fa fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                    @endforeach
                    @else
                    <tr>
                        <td colspan="12" align="center">NO Compaigns Found</td>
                    </tr>
                    @endif

                </tbody>
            </table>
            {{@$all_compaigns->links('vendor.pagination.bootstrap-4')}}
        </div>
    </div>
</div>
@endsection
