@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="col-12">
        <div class="page-title-box">
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Dashboard</a></li>
                    <li class="breadcrumb-item active">{{ isset($edit) ? 'Edit' : 'Add' }} Role</li>
                </ol>
            </div>
            <h4 class="page-title">{{ isset($edit) ? 'Edit' : 'Add' }} Role</h4>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="card-box">
            <h4 class="header-title m-t-0">{{ isset($edit) ? 'Edit' : 'Add' }} Role</h4>
            <p class="text-muted font-14 m-b-20">
                Here you can {{ isset($edit) ? 'edit' : 'add' }} Role.
            </p>

            <form action="{{ route('admin.roles.save') }}" class="ajaxForm" method="post" enctype="multipart/form-data">
                @csrf

                <div class="col-lg-12">
                    <div class="mb-3">
                        <label for="userRoleModal_name" class="form-label">Name</label>
                        <input type="text" class="form-control" id="userRoleModal_name" name="name" placeholder="Enter Staff Role Name" value="{{ $edit->name ?? null }}" required="">
                    </div>
                </div>

                <div class="col-12">
                    <fieldset>
                        <legend>Permission</legend>
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Read</th>
                                    <th>Write</th>
                                    <th>Update</th>
                                    <th>Delete</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        <h5>Dashboard</h5>
                                    </td>

                                    <td>
                                        <div class="col-md-4">
                                            <input type="checkbox" id="permission_1" value="dashboard-read" title="Dashboard Read" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'dashboard-read' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <h5>Company</h5>
                                    </td>

                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_2" value="company-read" title="company read" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'company-read' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_3" value="company-write" title="company Write" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'company-write' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_4" value="company-update" title="company Update" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'company-update' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_5" value="company-delete" title="company Delete" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'company-delete' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <h5>Products</h5>
                                    </td>

                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_6" value="products-read" title="products Read" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'products-read' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_7" value="products-write" title="products Write" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'products-write' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_8" value="products-update" title="products Update" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'products-update' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_9" value="products-delete" title="products Delete" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'products-delete' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <h5>Product</h5>
                                    </td>

                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_10" value="product-read" title="product Read" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'product-read' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_11" value="product-write" title="product Write" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'product-write' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_12" value="product-update" title="product Update" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'product-update' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_13" value="product-delete" title="product Delete" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'product-delete' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <h5>Bill</h5>
                                    </td>

                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_14" value="bill-read" title="bill Read" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'bill-read' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">
                                            <input type="checkbox" id="permission_15" value="bill-write" title="bill Write" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'bill-write' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">
                                            <input type="checkbox" id="permission_16" value="bill-update" title="bill Update" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'bill-update' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">
                                            <input type="checkbox" id="permission_17" value="bill-delete" title="bill
                                            Delete" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'bill-delete' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <h5>POS</h5>
                                    </td>

                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_18" value="pos-read" title="pos Read" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'pos-read' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                    </td>
                                    <td>
                                    </td>
                                    <td>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <h5>Stock Management</h5>
                                    </td>

                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_19" value="stock-read" title="stock Read" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'stock-read' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                    </td>
                                    <td>
                                    </td>
                                    <td>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <h5>Report</h5>
                                    </td>

                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_20" value="report-read" title="report Read" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'report-read' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                    </td>
                                    <td>
                                    </td>
                                    <td>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <h5>Role</h5>
                                    </td>

                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_23" value="role-read" title="role Read" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'role-read' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_24" value="role-write" title="role Write" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'role-write' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_25" value="role-update" title="role Update" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'role-update' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_26" value="role-delete" title="role Delete" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'role-delete' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <h5>Staff Management</h5>
                                    </td>

                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_27" value="staff-read" title="staff Read" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'staff-read' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_28" value="staff-write" title="staff Write" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'staff-write' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_29" value="staff-update" title="staff Update" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'staff-update' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="col-md-4">

                                            <input type="checkbox" id="permission_30" value="staff-delete" title="staff Delete" name="permission[]" @if (isset($edit)) @foreach ($user_permissions as $permission) {{ 'staff-delete' == $permission->name ? 'checked' : null }} @endforeach @endif>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </fieldset>
                </div>
                @if (isset($edit))
                <input type="hidden" name="role_id" value="{{ $edit->id }}">
                @endif
                <div class="form-group mb-3 text-right">
                    <button class="btn btn-primary waves-effect waves-light" type="submit">
                        Submit
                    </button>
                </div>

            </form>
        </div>
    </div>
</div>
@endsection

@section('page-scripts')
<script>
    $(document).ready(function() {
        $('.ajaxForm').submit(function(e) {
            e.preventDefault();
            let validations = $(".ajaxForm").validate();
            if (validations.errorList.length != 0) {
                return false;
            }
            var url = $(this).attr('action');
            var param = new FormData(this);
            my_ajax(url, param, 'post', function(res) {

            });
        })
    });
</script>
@endsection
