<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\HomeController as FrontHome;
use App\Http\Controllers\Auth\SocialController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//auth routes for normal user
Auth::routes(['verify' => true, 'register' => true]);


Route::namespace('Auth')->group(function () {
    Route::POST('/register/save', 'RegisterController@create')->name('register.save');
    Route::POST('/login', 'LoginController@login')->name('front.login');
    Route::get('/logout', 'LoginController@logout')->name('front.logout');
});

//admin auth routes
Route::namespace('Auth')->group(function () {
    Route::get('/login', 'AdminLoginController@showLoginForm')->name('admin.login');
    Route::post('/logout', 'AdminLoginController@logout')->name('admin.logout');
    Route::post('/login', 'AdminLoginController@login')->name('admin.login.submit');
    Route::post('/password/reset', 'AdminResetPasswordController@reset')->name('admin.password.update');
    Route::post('/password/forget/password', 'AdminForgotPasswordController@sendResetLinkEmail')->name('admin.password.email');
    Route::get('/password/reset', 'AdminForgotPasswordController@showLinkRequestForm')->name('admin.password.request');
    Route::get('/password/reset/{token}', 'AdminResetPasswordController@showResetForm')->name('admin.password.reset');
});

//protected admin routes
Route::middleware(['auth:admin', 'is_active'])->namespace('Administrator')->group(function () {
    Route::get('/', 'HomeController@index')->name('admin.home');

    //profile pages
    Route::get('/update-profile', 'StaffController@update_profile')->name('admin.update_profile');
    Route::post('/save-profile', 'StaffController@save_profile')->name('admin.save_profile');
    Route::post('/change-password', 'StaffController@change_password')->name('admin.change_password');

    //Staffs routes
    Route::get('/staff', 'StaffController@index')->name('admin.staff');
    Route::get('/staff/add', 'StaffController@add')->name('admin.staff.add');
    Route::get('/staff/edit/{user_id}', 'StaffController@edit')->name('admin.staff.edit');
    Route::post('/staff/save', 'StaffController@save')->name('admin.staff.save');
    Route::post('/staff/update_password', 'StaffController@update_password')->name('admin.staff.update_password');
    Route::get('/staff/update-status/{user_id}', 'StaffController@updateStatus')->name('admin.staff.update_status');
    Route::get('/staff/delete/{user_id}', 'StaffController@delete')->name('admin.staff.delete');

    //notification routes
    // Route::get('/notification', 'NotificaitonController@index')->name('admin.notifications');
    // Route::get('/notification/get_all_notifications', 'NotificaitonController@get_all_notificaitons')->name('admin.notification.all');
    // Route::get('/notification/mark_all_read', 'NotificaitonController@mark_all_read')->name('admin.notifications.all_read');
    // Route::get('/notification/mark_as_read/{id}', 'NotificaitonController@mark_single_notification_read')->name('admin.notifications.mark_as_read');
    // Route::get('/notification/delete_all', 'NotificaitonController@delete_notifications')->name('admin.notifications.delete_all');


    //Permission type routes
    Route::get('/permission-type', 'PermissionController@permissionn_type_all')->name('admin.permissionn-type');
    Route::post('/permissionn-type/save', 'PermissionController@permissionn_type_save')->name('admin.permissionn-type.save');
    Route::get('/permissionn-type/delete/{permission_id?}', 'PermissionController@permissionn_type_delete')->name('admin.permissionn-type.delete');

    // Permissions routes
    Route::get('/permissions', 'PermissionController@index')->name('admin.permissions');
    Route::post('/permissions/save', 'PermissionController@save')->name('admin.permissions.save');
    Route::get('/permissions/delete/{permission_id?}', 'PermissionController@delete')->name('admin.permissions.delete');

    // Roles
    Route::get('/role', 'RoleController@index')->name('admin.roles');
    Route::get('/role/add', 'RoleController@add')->name('admin.role.add');
    Route::post('/role/save', 'RoleController@save')->name('admin.roles.save');
    Route::get('/role/edit/{id}', 'RoleController@edit')->name('admin.role.edit');
    Route::get('/role/delete/{id}', 'RoleController@delete')->name('admin.role.delete');

    // websites routes
    Route::get('/websites', 'WebsiteController@index')->name('admin.websites');
    Route::post('/website/save', 'WebsiteController@save')->name('admin.website.save');
    Route::get('/website/edit/{id}', 'WebsiteController@edit')->name('admin.website.edit');
    Route::get('/website/delete/{id}', 'WebsiteController@delete')->name('admin.website.delete');

    // Compaigns Route
    Route::get('/compaigns', 'CompaignController@index')->name('admin.compaigns');
    Route::get('/compaign/add', 'CompaignController@add')->name('admin.compaign.add');
    Route::post('/compaign/save', 'CompaignController@save')->name('admin.compaign.save');
    Route::get('/compaign/edit/{id}', 'CompaignController@edit')->name('admin.compaign.edit');
    Route::get('/compaign/delete/{id}', 'CompaignController@delete')->name('admin.compaign.delete');

    Route::prefix('campaign-ads')->as('admin.campaign_ads.')->group(function(){
        Route::get('/set/{id}','CompaignController@set_campaign_ads')->name('set');
        Route::post('/save','CompaignController@campaign_ads_save')->name('save');
        Route::get('/edit/{id}/{campaign_id}','CompaignController@edit_campaign_ads')->name('edit');
        Route::get('/delete/{id}','CompaignController@delete_campaign_ads')->name('delete');
        Route::get('/ads_ifram_generate/{id}','CompaignController@ads_ifram_generate')->name('ads_ifram_generate');

    });
});

Route::prefix('artisan/command')->name('artisan.command.')->group(function () {
    Route::get('/config_cache', 'ArtisanCommandController@config_cache')->name('config_cache');
    Route::get('/route_cache', 'ArtisanCommandController@route_cache')->name('route_cache');
    Route::get('/cache_clear', 'ArtisanCommandController@cache_clear')->name('cache_clear');
    Route::get('/route_list', 'ArtisanCommandController@route_list')->name('route_list');
    Route::get('/migrate', 'ArtisanCommandController@migrate')->name('migrate');
});

Route::get('/ads_ifram_view/{id}','Administrator\CompaignController@ads_ifram_view')->name('ads_ifram_view');
Route::get('/count-clicks','Administrator\CompaignController@update_click_count')->name('ads_clicks');
Route::get('/count-views','Administrator\CompaignController@update_view_count')->name('ads_views');
// Route::get('auth/google', [SocialController::class, 'redirectToGoogle'])->name('auth.google');
// Route::get('auth/google/callback', [SocialController::class, 'handleGoogleCallback'])->name('google.callback');


// Route::get('auth/facebook', [SocialController::class, 'redirectToFacebook'])->name('auth.facebook');
// Route::get('auth/facebook/callback', [SocialController::class, 'handleFacebookCallback'])->name('facebook.callback');
