
<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="page-title-box">
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.home')); ?>">Dashboard</a></li>
                    <li class="breadcrumb-item active"><?php echo e($title); ?></li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="card-box">
            <h4 class="header-title m-t-0"><?php echo e(!isset($edit) ? 'Add ' : 'Edit '); ?><?php echo e($title); ?></h4>
            <p class="text-muted font-14 m-b-20">
                Here you can <?php echo e(!isset($edit) ? 'Add ' : 'Edit '); ?><?php echo e($title); ?>.
            </p>

            <form action="<?php echo e(route('admin.website.save')); ?>" class="ajaxForm" method="post" enctype="multipart/form-data" novalidate>
                <?php echo csrf_field(); ?>
                <div class="row">


                    <div class="form-group mb-3 col-md-6">
                        <label for="title">Website Name<span class="text-danger">*</span></label>
                        <input class="form-control" type="text" name="name" value="<?php echo e($edit->name ?? ''); ?>" placeholder="Enter Website Name" required>
                    </div>

                    <div class="form-group mb-3 col-md-6">
                        <label for="status">Staus<span class="text-danger">*</span></label>
                        <select class="form-control" name="status" id="" required>
                            <option value="">--Select--</option>
                            <option value="1" <?php echo e(@$edit->status == "1" ? 'selected' : ' '); ?>>Active</option>
                            <option value="0" <?php echo e(@$edit->status == "0" ? 'selected' : ' '); ?>>Deactive</option>
                        </select>
                    </div>

                </div>
                <input type="hidden" name="id" value="<?php echo e($edit->hashid ?? ''); ?>">
                <div class="form-group mb-3 text-right">
                    <button class="btn btn-primary" type="submit">
                        Submit
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="card-box">
            <div class="d-flex align-items-center justify-content-between">
                <h4 class="header-title">All Websites</h4>
            </div>
            <p class="sub-header">Following is the list of all the Websites.</p>
            <table id="responsive-datatable" class="table table-bordered dt-responsive nowrap">
                <thead class="text-center">
                    <tr>
                        <th width="20">S.No</th>
                        <th>Name</th>
                        <th>Status</th>
						<th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(!empty($all_websites) && count($all_websites) > 0): ?>
                    <?php $__currentLoopData = $all_websites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="text-center align-middle"><?php echo e($key+1); ?></td>
                        <td class="text-center align-middle"><?php echo e($value->name); ?></td>
						<td class="text-center align-middle">
                            <p class="m-0"><small class="badge <?php echo e($value->status == 1 ? 'bg-success':'bg-danger'); ?>"><?php echo e($value->status == 1 ? 'Active':'Deactive'); ?></small></p>
                        </td>
                        <td class="text-center align-middle">
                            <a href="<?php echo e(route('admin.website.edit',$value->hashid)); ?>" class="btn btn-icon btn-sm waves-effect waves-light btn-warning" title="Edit"> <i class="fas fa-edit"></i></a>
                            <button type="button" onclick="ajaxRequest(this)" data-url="<?php echo e(route('admin.website.delete',$value->hashid)); ?>" class="btn btn-icon btn-sm waves-effect waves-light btn-danger" title="Delete">
                                <i class="fa fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                    <tr>
                        <td colspan="12" align="center">NO Websites Found</td>
                    </tr>
                    <?php endif; ?>

                </tbody>
            </table>
            <?php echo e(@$all_websites->links('vendor.pagination.bootstrap-4')); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-scripts'); ?>
<script>
    $(document).ready(function() {
        validations = $(".ajaxForm").validate();
        $('.ajaxForm').submit(function(e) {
            e.preventDefault();
            validations = $(".ajaxForm").validate();
            if (validations.errorList.length != 0) {
                return false;
            }
            var url = $(this).attr('action');
            var param = new FormData(this);
            my_ajax(url, param, 'post', function(res) {

            });
        })
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Xampp\htdocs\ads_management_system\resources\views/admin/websites/index.blade.php ENDPATH**/ ?>